<%@include file="/WEB-INF/includeTemplate.inc"%>
<%@ taglib prefix="spring" uri="/WEB-INF/tld/spring.tld"%>
<%@ taglib uri="/WEB-INF/tld/tiles-jsp.tld" prefix="tiles"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>

<!-- Inicio Calculo Section -->
<section id="calculo">
<div class="container">
	<div class="row">
		<div class="col-lg-12 text-center">
			<h3 class="section-heading"><spring:message code="menu.calculo"/></h3>
			<h3 class="section-subheading text-muted"><spring:message code="descripcion.calculo"/></h3>
		</div>
	</div>
	
	<!--ROW-->
	<div class="row">
		<div id="introduccionDatos" class="col-md-12">
			<div class="row">
				<div class="col-md-12">
					<div class="panel-group" id="calculoBobinas">
						<div class="panel panel-primary">
							<div class="panel-heading">
								<h4 class="panel-title">
									<a data-toggle="collapse" href="#datosSimulacion"> <spring:message code="datos.titulo"/></a>
								</h4>
							</div>
							<div id="datosSimulacion" class="panel-collapse collapse in">
								<div class="panel-body">
									<h5>
										<spring:message code="datos.transporte"/>
										<img src="${staticsUrl}/aa94a/images/help.png" id="ayudaTransporte" class="img-rounded img-responsive img-display img-ayuda" alt="<spring:message code="alt.ayuda" />" title="<spring:message code="alt.ayuda" />" />
									</h5>
									<div id="divTransporte" class="alert alert-info">
										<a class="close" id="closeTransporte" aria-label="close" title="<spring:message code="cerrar" />" >&times;</a>
										<spring:message code="datos.transporte.descripcion"/>
									</div>
									<div class="row">
										<div class="col-md-12">
											<!-- Nav tabs -->
											<ul class="nav nav-tabs" role="tablist" id="templatemo-tabs">
												<li class="active"><a href="#tipoVehiculo" role="tab"
													data-toggle="tab"><spring:message code="datos.vehiculo"/></a></li>
												<li><a href="#tipoSujecion" role="tab"
													data-toggle="tab"><spring:message code="datos.tiposujecion"/></a></li>
												<li><a href="#tipoDensidad" role="tab" 
													data-toggle="tab"><spring:message code="datos.material"/></a></li>
											</ul>

											<!-- Inicio Tab -->
											<div class="tab-content">
												<div class="tab-pane fade in active" id="tipoVehiculo">													
													<div class="row">
														<div class="col-md-12 col-xs-12">
															<c:forEach var="vehiculo" items="${vehiculos}">
																<a onclick="seleccionaVehiculo(${vehiculo.codigo})" onkeypress="seleccionaVehiculo(${vehiculo.codigo})" id="selVehiculo${vehiculo.codigo}" class="a-btn col-md-12 col-xs-12"> 
																<span class="a-btn-slide-text"></span> <img
																	src="${staticsUrl}/aa94a/images/${vehiculo.imagen}" class="img-rounded img-responsive img-display thumb"	alt="" /> 
																	<span class="a-btn-text">${vehiculo.desc}</span>
																	 <span id="seleccionaVehiculoSpan${vehiculo.codigo}" class="a-btn-icon-right"><span></span>
																	</span> 
																</a>
															</c:forEach>															
														</div>
													</div>
												</div>
												<div class="tab-pane fade" id="tipoSujecion">													
													<div class="row">
														<div class="col-md-12 col-xs-12">
															<c:forEach var="tipoSujecion" items="${tiposSujecion}">
																<a onclick="seleccionaTipoSujecion(${tipoSujecion.codigo})" onkeypress="seleccionaTipoSujecion(${tipoSujecion.codigo})"
																id="selTipoSujecion${tipoSujecion.codigo}" class="a-btn2 col-md-12 col-xs-12">
																<span class="a-btn-slide-text"></span> <img
																src="${staticsUrl}/aa94a/images/${tipoSujecion.imagen}"
																class="img-rounded img-responsive img-display thumb"
																alt="" /> <span class="a-btn-text2">${tipoSujecion.desc}</span> 
																<span id="seleccionaTipoSujecionSpan${tipoSujecion.codigo}"
																class="a-btn-icon-right"><span></span></span></a>
															</c:forEach>
														</div>
													</div>
												</div>
												<div class="tab-pane fade" id="tipoDensidad">
													<div class="row">
														<div class="col-md-12 col-xs-12">
															<c:forEach var="densidad" items="${densidades}">
																<a onclick="seleccionaDensidad(${densidad.codigo})" onkeypress="seleccionaDensidad(${densidad.codigo})" id="selDensidad${densidad.codigo}"
																	class="a-btn3 col-md-12 col-xs-12"> <span
																	class="a-btn-slide-text"></span> <span
																	class="a-btn-text3">${densidad.desc}</span>
																	<span id="seleccionaDensidadSpan${densidad.codigo}"
																	class="a-btn-icon-right"><span></span>
																</span> 
																</a>
															</c:forEach>
														</div>
													</div>
												</div>
											</div>
											<!-- Fin Tab -->
										</div>
									</div>
																	
									
									<h5 id="datosCarga">
										<spring:message code="datos.carga"/>
										<img src="${staticsUrl}/aa94a/images/help.png" id="ayudaCarga" class="img-rounded img-responsive img-display img-ayuda" alt="<spring:message code="alt.ayuda" />" title="<spring:message code="alt.ayuda" />" />
									</h5>
									<div id="divCarga" class="alert alert-info">
										<a class="close" id="closeCarga" aria-label="close" title="<spring:message code="cerrar" />" >&times;</a>
									 	<spring:message code="datos.carga.descripcion"/> <spring:message code="datos.pesoestimado"/>
									</div>
									<!-- Fila con anchura y diametros -->
									<div class="row">
										<div class="col-md-3">
											<label for="anchura" class="col-md-12 control-label"><spring:message code="campo1"/> <input type="number"
												name="anchura" id="anchura" class="form-control" min="0"
												placeholder="<spring:message code='placeholder.anchura'/>"></label>
										</div>
										<div class="col-md-3">
											<label for="dexterior" class="col-md-12 control-label"><spring:message code="campo2"/></label> <input type="number"
												name="dexterior" id="dexterior" class="form-control" min="0"
												placeholder="<spring:message code='placeholder.diametroext'/>"></label>
										</div>
										<div class="col-md-3">
											<label for="dinterior" class="col-md-12 control-label"><spring:message code="campo3"/></label>
											<input type="number" name="dinterior" id="dinterior" class="form-control" min="0"
										  	placeholder="<spring:message code='placeholder.diametroint'/>"></label>
										</div>
									</div>
									<br />
									<div class="row">
										<div class="col-md-12" id="pesoestimado"></div>
									</div>
									
									<!-- Fila para el peso y el boton Calcular -->
									<div class="row">
										<div class="col-xs-6">
											<label for="peso" class="col-md-12 control-label"><spring:message code="campo4"/></label>
											 <input type="number" name="peso" id="peso" class="form-control" min="0"
											 placeholder="<spring:message code='placeholder.peso'/>"></label>
										</div>
										
										<br />
										<div class="col-xs-6">
											<a  id="pesoEstimado" onclick="pesoEstimado()" onkeypress="pesoEstimado()"
												class="btn btn-primary btn-md boton formaBoton"><spring:message code="botonpeso"/></a>
										</div>
									</div>
									<br />
									<!-- Fila para el mensaje de error -->
									<div class="row">
										<div id="mensajeErrores" class="col-md-12" style="display: none"></div>
									</div>
									<br />
									<!-- Fila para el resto de botones -->
									<div class="row">
										<div class="col-md-12">
											<a  id="addBobina" onclick="addBobina()" onkeypress="addBobina()"
												class="btn btn-primary btn-md boton formaBoton"><spring:message code="botonanadir"/></a>
											<a  class="btn btn-primary btn-md boton formaBoton"
												onclick="realizarCalculo()" onkeypress="realizarCalculo()" 
												title="<spring:message code="botoncalcular"/>"><span class="glyphicon glyphicon-cog"></span>
												<spring:message code="botoncalcular"/></a>
											<a class="btn btn-primary btn-md boton formaBoton"
												onclick="limpiar()" onkeypress="limpiar()" href="#transporte" title="Borrar"><spring:message code="botonborrar"/></a>
										</div>
									</div>

									<br/>
									<div class="row">
										<!--Tabla Bobinas Inicio-->
										<div class="col-md-12 col-sm-12 margin-bottom-30">											
											<div class="panel panel-primary">											
												<div class="panel-heading text-center"><spring:message code="texto.tabla"/></div>
													<div class="panel-body">													
														<div class="table-responsive">
															<table id="tablaBobinas" class="table table-striped">
																<thead>
																	<tr>
																		<th class="text-center"><spring:message code="solucion.anchura"/></th>
																		<th class="text-center"><spring:message code="solucion.diametroext"/></th>
																		<th class="text-center"><spring:message code="solucion.peso"/></th>
																		<th class="text-center"></th>
																	</tr>
																</thead>
																<tbody>
																	
																</tbody>
															</table>
														</div>
													</div>
												</div>
											</div>
										</div>
										<!-- Fin row -->
									<br/>									
								</div>
							</div>
							<!-- Fin Datos Simulacion -->
						</div>
					</div>
				</div>
			</div>
		</div>
		<!-- Fin introduccionDatos -->
	
		<div id="presentacionResultado" style="display: none">
			<!--Inicio grupo-->
			<div class="panel-group" id="calculoResultado">
				<div class="panel panel-primary">
					<div class="panel-heading">
						<h4 class="panel-title">
							<a data-toggle="collapse" href="#resultadoSimulacion">
								<spring:message code="titulo1"/>
							 
							</a>
						</h4>
					</div>
					<div id="resultadoSimulacion" class="panel-collapse collapse in">
						<div class="panel-body">
							<div class="alert alert-info">
								<spring:message code="descripcion1.1"/>
							</div>
							<div class="row">
								<div class="col-md-6 col-xs-6">
									<div class="btn-group">
										<button type="button" class="btn btn-default"><spring:message code="solucion.imprimir"/></button>
										<button type="button" class="btn btn-default dropdown-toggle"
											data-toggle="dropdown">
											<span class="caret"></span>
										</button>
										<ul class="dropdown-menu" role="menu">
											<li><a onclick="generarPdf()" onkeypress="generarPdf()"><spring:message code="imprimir.formato1"/></a>
											</li>
											<li><a onclick="generarExcel()" onkeypress="generarExcel()"><spring:message code="imprimir.formato2"/></a>
											</li>
											<li><a onclick="generarHtml()" onkeypress="generarHtml()"><spring:message code="imprimir.formato3"/></a>
											</li>
										</ul>
									</div>
								</div>								
								<div class="col-md-6 col-xs-6">
									<div class="btn-group">
										<button type="button" class="btn btn-default"><spring:message code="solucion.formato"/></button>
										<button type="button" class="btn btn-default dropdown-toggle"
											data-toggle="dropdown">
											<span class="caret"></span>
										</button>
										<ul class="dropdown-menu" role="menu">
											<li><a onclick="formatoTabla()"><spring:message code="formato.tabla"/></a>
											</li>
											<li><a onclick="formatoTablaGrafico()"><spring:message code="formato.tablagrafico"/></a>
											</li>
										</ul>
									</div>
								</div>
							</div>
							<br />

							<h5><spring:message code="titulo2"/></h5>
							<div class="row">
								<div class="col-md-12 col-sm-12 margin-bottom-30">
									<div class="panel panel-primary">
										<div class="panel-heading text-center"><spring:message code="titulo3"/></div>
										<div class="panel-body">
											<div class="table-responsive">
												<table id="tablasol" class="table table-striped">
													<thead>
														<tr>
															<th class="text-center"><spring:message code="solucion.id"/></th>
															<th class="text-right"><spring:message code="solucion.anchura"/></th>
															<th class="text-right"><spring:message code="solucion.diametroext"/> </th>
															<th class="text-right"><spring:message code="solucion.peso"/>
															</th>
															<th class="text-right"><spring:message code="solucion.distancia"/></th>
														</tr>
													</thead>
													<tbody>														
													</tbody>
												</table>
											</div>
										</div>
									</div>
								</div>
							</div>
							<br />
							<div class="row">
								<div class="col-md-12 col-sm-12 margin-bottom-30">
									<p>
										(*)
										<i id="distanciasol">
										</i>
									</p>
								</div>
							</div>
							<br />
							<div id="ubicacionGrafico" class="row">
								<div id="graficosol" class="col-md-12 col-sm-12 margin-bottom-30">
									
								</div>
							</div>
							<br />
							<!--Ubicacion Fin-->
							<!--Estiba Inicio-->
							<h5><spring:message code="titulo4"/></h5>
							<div class="row">
								<div class="col-md-12 col-sm-12 margin-bottom-30">
									<div class="panel panel-primary">
										<div class="panel-heading text-center"><spring:message code="titulo5"/></div>
										<div class="panel-body">
											<div id="estibaTablaGrafico">
												<table id="estibasol" class="table table-striped">
													<thead>
														<tr>
															<th class="text-center"><spring:message code="texto.estibas"/></th>
															<th class="text-center"></th>
														</tr>
													</thead>
													<tbody>														
													</tbody>
												</table>
											</div>
											<div id="estibaTabla" class="table-responsive oculto">
												<table class="table table-striped" id="estibasol2">
													<thead>
														<tr>
															<th class="text-center"><spring:message code="texto.estibas"/></th>
														</tr>
													</thead>
													<tbody>
													</tbody>
												</table>
											</div>
										</div>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
</div>		
</section>	


<form id="generarReport" action="" target="_blank">
</form>